%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 5 - Section 2: TX_Waveform_Mapping
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 264)

function [OutputSamples] = TX_Waveform_Mapping(InputSymbols, OSR, Alpha, Delay)

NumberOfSymbols     =    length(InputSymbols);

%% 1. The Zero Stuffing Process (there is nothing to it)
SampleStream                     = zeros(1, NumberOfSymbols*OSR);
for i = 1:NumberOfSymbols
    SampleStream(1, 1 + (i*OSR)) = InputSymbols(1,i);
end

%% 2. The Pulse Shaping Process
[num,den]     = rcosine(1,OSR,'default',Alpha, Delay);
OutputSamples = filter(num, den, SampleStream);

return   %% uncomment for additional plot

figure(1);
subplot(2,2,1);
stem(real(SampleStream), 'k', 'LineWidth', .8); grid on; title('I Sample Stream Before Pulse Shaping');
set(gca, 'YTick', [-.707 0 .707]); 
axis([0 125 -1 1]); set(gca,  'LineWidth', 1);
subplot(2,2,3);
stem(imag(SampleStream), 'k', 'LineWidth', .8); grid on; title('Q Sample Stream Before Pulse Shaping');
set(gca, 'YTick', [-.707 0 .707]); 
axis([0 125 -1 1]); set(gca,  'LineWidth', 1);
subplot(2,2,[2 4]);
stem(num, 'k', 'LineWidth', .8); title('Impulse Response of Filter'); grid on;
axis([0 33 -.2 1.2]); set(gca,  'LineWidth', 1);