%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 7 - Section 1: Comparing Diversity Combining Schemes
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013


clc
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 381)

SNR1 = 10*ones(1,20);
SNR2 = 1:1:20;

Maximum_Output_Combining  = max(SNR1, SNR2);
Equal_Gain_Combining      = 4*SNR1.*SNR2./(SNR1 + SNR2);
Maximum_Ratio_Combining   = SNR1 + SNR2;


figure(1);
plot(SNR2, Maximum_Output_Combining, 'k'); title('Final SNR for Different Combining Techniques'); hold on
plot(SNR2, Equal_Gain_Combining, 'k:');
plot(SNR2, Maximum_Ratio_Combining, 'k');
xlabel('SNR2 - linear'); ylabel('Linear SNR of Final Estimate'); axis([1 20 5 30]);
legend('Signal Strength Diversity','Equal Gain Combining', 'Maximum Ratio Combining');

