%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 7 - Section 3: Spatial Multiplexing 2x3 Example
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013


clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 390)

randn('state',0);

%% Computing Autocorrelation Matrices
Noise_var  = [.001; .001; .001]; %% Noise Variances
Rv         = diag(Noise_var); %% Noise Autocorrelation Matrix

Signal_var = [1; 1];          %% Signal Variances
Rx         = diag(Signal_var);%% Signal Autocorrelation Matrix

%% Define Channel Matrix H (Dimension is 3x2)
H          = [0.4+j 1.2-0.5*j; 0.9+j*0.1 1.4+j; 1.1-j*0.3  0.4-j];

%% Computing the Wiener-Hopf Solution
EC         = Rx*H'*inv(H*Rx*H' + Rv); %% Optimal estimator coefficients


%% Generating Example Symbols and Noise
X0         = [-1; j];         %% Input Symbol column vector
Noise_std  = sqrt(Noise_var); 
V0         = Noise_std.*(.707*randn(3,1) + j*.707*randn(3,1)) 
                              %% Input Noise column vector                   
Y0 = H*X0 + V0               %% Observed Output column vector


%% Computing the optimum estimator coefficients
X0_estimate = EC*Y0;            %% estimate of input symbols

X0_estimate
EC