%% Text: Digital Signal Processing in Modern Communication Systems
%% Chapter 7 - Section 3: Verifying Maximum Ratio Combining
%% Copyright: Andreas Schwarzinger May 2013
%%
%% Author: Andreas Schwarzinger                              May 2013

clc;
clear all;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Code (Page 391)

randn('state',0);

%% Computing Autocorrelation Matrices
Noise_var  = [.1; .2; .2]; %% Noise Variances
Rv         = diag(Noise_var); %% Noise Autocorrelation Matrix

Signal_var = [1];             %% Signal Variances
Rx         = diag(Signal_var);%% Signal Autocorrelation Matrix

%% Define Channel Matrix H (Dimension is 3x2)
H          = [1; 1; 1];

%% Computing the Wiener-Hopf Solution
EC         = Rx*H'*inv(H*Rx*H' + Rv); %% Optimal estimator coefficients

EC